#include <bits/stdc++.h>
using namespace std;

struct Node {
	int name;
	int id;
	vector<Node*> children;
	Node* parentNode = nullptr;

	Node(int oid, int oname, Node* oroot)
		: name(oname), id(oid), parentNode(oroot) {}
};

Node* findNodeById(int id, Node* currentNode) {
	if (currentNode->id == id) {
		return currentNode;
	}
	for (auto* node : currentNode->children) {
		Node* a = findNodeById(id, node);
		if (a != nullptr) {
			return a;
		}
	}
	return nullptr;
}

Node* findNodeByName(int name, Node* currentNode) {
	if (currentNode->name == name) {
		return currentNode;
	}
	for (auto* node : currentNode->children) {
		Node* a = findNodeByName(name, node);
		if (a != nullptr) {
			return a;
		}
	}
	return nullptr;
}



void print(const Node* currentNode) {
	cout << "+" << endl;
	cout << currentNode->name << endl;
	for (const auto* node : currentNode->children) {
		print(node);
	}
	cout << "-" << endl;
}

int	findDistanceFromNodeToNode(Node* currentNode, Node* target, Node* from, unordered_map<Node*, int>& mapv) {
	if (mapv[currentNode] != 0) {
		return mapv[currentNode];
	}
	if (currentNode == target) {
		mapv[currentNode] = 1;
		return 1;
	}
	for (auto* a : currentNode->children) {
		if (a != from) {
			int b = findDistanceFromNodeToNode(a, target, currentNode, mapv);
			if (b != 0) {
				return b + 1;
			}
		}
	}
	if (currentNode->parentNode != from) {
		int b = findDistanceFromNodeToNode(currentNode->parentNode, target, currentNode, mapv);
		if (b != 0) {
			return b + 1;
		}
	}
	return 0;
}


int main(int argc, char const *argv[])
{
    ios_base::sync_with_stdio(false);
	cin.tie(NULL); cout.tie(NULL);
	int n;
	cin >> n;
	vector<int> vec(n + 1);
	for (int i = 1; i <= n; i++) {
		cin >> vec[i];
	}

	Node* root;
	root = new Node(1, vec[1], nullptr);

	unordered_map<int, Node*> mapname;
	unordered_map<int, Node*> mapid;
	mapname[root->name] = root;
	mapid[root->id] = root;


	for (int i = 0; i < n - 1; i++) {
		int a, b;
		cin >> a >> b;
		Node* nodea = mapid[a];

		Node* newnode = new Node(b, vec[b], nodea);
		nodea->children.push_back(newnode);
		mapname[vec[b]] = newnode;
		mapid[b] = newnode;
	}
    cout << 0 << endl;
    return 0;
    
	int q = 0, t, ia, ib, l, r, x;
	cin >> q;
	for (int i = 0; i < q; i++) {
		cin >> t;
		if (t == 1) {
			cin >> ia >> ib;

			//SPED THIS UP
//			int a = mapname[ia]->name;
//			mapname[ia]->name = mapname[ib]->name;
//			mapname[ib]->name = a;
//
//			Node* nodea = mapname[ia];
//			mapname[ia] = mapname[ib];
//			mapname[ib] = nodea;
		}
		else if (t == 2) {
			cin >> l >> r >> x;
//			int maxi = 0;
//			Node* startingNode = mapname[x];
//			unordered_map<Node*, int> mapv;
//
//			for (int i = l; i <= r; i++)
//				maxi = max(maxi, findDistanceFromNodeToNode(mapname[i], startingNode, nullptr, mapv) - 1);
//			cout << maxi << endl;
		}

	}
	//print(root);


	return 0;
}